<?php
/**
 * Order Status Model
 *
 * PHP Version 7
 *
 * @category Mtc\Shop\Order
 * @package  Mtc\Shop
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */

namespace Mtc\Shop\Order;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * Store statuses that can be applied to orders.
 *
 * @category Mtc\Shop\Order
 * @package  Mtc\Shop
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */
class OrderStatus extends Model
{
    /**
     * As this will be called on each order through 'status_id', we do not
     * want these to be removed completely... merely hidden from view so
     * we may still access when required.
     */
    use SoftDeletes;

    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [
        'is_email_sent' => 'boolean',
    ];

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'title',
        'is_email_sent',
        'email_body',
    ];

    /**
     * Get the orders associated with the status.
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function orders()
    {
        return $this->hasMany(Order::class);
    }
}
