<?php
/**
 * Basket Total Event
 *
 * PHP Version 7
 *
 * @category Mtc\Shop\Events
 * @package  Mtc\Shop
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */


namespace Mtc\Shop\Events;

use Mtc\Shop\Contracts\BasketContract;

/**
 * Provide an event for price methods to apply themselves
 * as part of the basket.
 *
 * @category Mtc\Shop\Events
 * @package  Mtc\Shop
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */
class BasketTotal
{
    /**
     * The basket model.
     *
     * @var null|OrderContract
     */
    public $basket = null;

    /**
     * Build the new event, adding in the basket model.
     *
     * @param OrderContract $basket Incoming Basket
     *
     * @return void
     */
    public function __construct(BasketContract $basket)
    {
        $this->basket = $basket;
    }
}
