@extends('core::layouts.admin')

@section('title', $title)

@section('subtitle', $subtitle)

@section('content')

{{--     <form method="POST" action="">

        <div class="well well-sm">
            <button type="submit"
                    class="btn btn-success"
                    >Save</button>
        </div> --}}

        <div class="well well-sm hidden-print">

            <div class="btn-group">

                <button type="button"
                        class="btn btn-default dropdown-toggle"
                        data-toggle="dropdown"
                        aria-haspopup="true"
                        aria-expanded="false">
                    {{ trans('shop::fields.actions') }}
                    <span class="caret"></span>
                </button>

                <ul class="dropdown-menu">
                    <li>
                        <a href="#" class="btn btn-defualt" data-toggle="modal" data-target="#payment_information">
                            {{ trans('shop::order.view_payment_data') }}
                        </a>
                    </li>
                </ul>

                <a class="btn btn-primary" href="#" onclick="javascript:print()">
                    {{ trans('shop::order.print_dispatch_note') }}
                </a>
            </div>

            <form class="form-inline pull-right">
                <div class="form-group">
                    <label for="status">{{ trans('fields.status') }}</label>
                    <select name="status" class="form-control"></select>
                </div>
            </form>

            <div class="clear"></div>
        </div>

        <div class="row">
            <div class="col col-md-9">

                <div class="panel panel-default">
                    <table class="table panel-body" id="order_items">
                        @foreach ($order->items as $item)
                            <tr>
                                <td>
                                    <strong>{{ $item->product_title }}</strong><br />
                                    <i class="text-muted">{{ $item->variant_title }}</i>
                                </td>
                                <td>
                                    @currency($item->price) x {{ $item->quantity }}
                                </td>
                                <td class="text-right">
                                    @currency($item->price * $item->quantity)
                                </td>
                            </tr>
                        @endforeach
                        <tr>
                            <td></td>
                            <td colspan="2">
                                <table class="table">
                                    <tr>
                                        <td>{{ ucfirst(trans('shop::basket.subtotal')) }}</td>
                                        <td class="text-right">@currency($order->getCostSubtotalAttribute())</td>
                                    </tr>
                                    @foreach ($order->surcharges as $surcharge)
                                        <tr>
                                            <td>{{ $surcharge->display_name }}</td>
                                            <td class="text-right">@currency($surcharge->value)</td>
                                        </tr>
                                    @endforeach
                                    @foreach ($order->discounts as $discount)
                                        <tr>
                                            <td>{{ ucfirst(trans('shop::basket.discount')) }}: {{ $discount->discount_reference }}</td>
                                            <td class="text-right">-@currency($discount->value)</td>
                                        </tr>
                                    @endforeach
                                    <tr>
                                        <td><strong>{{ trans('shop::basket.total') }}</strong></td>
                                        <td class="text-right">
                                            <strong>
                                                @currency($order->total)
                                            </strong>
                                        </td>
                                    </tr>
                                </table>
                            </td>
                        </tr>
                    </table>
                </div>

                <div class="panel panel-default hidden-print" id="orderNotes">
                    <div class="panel-heading">
                        <h3 class="panel-title">
                            {{ trans('shop::order.notes') }}
                            <button class="btn btn-default btn-xs" data-toggle="modal" data-target="#newNote">&plus;</button>
                        </h3>
                    </div>
                    <div>

                        <ul class="list-group list-group-simple">
                            @foreach ($order->notes as $note)
                                <li class="list-group-item">
                                    <p>
                                        <strong>
                                            {{ $note->created_at->toDayDateTimeString() }}
                                            <span class="text-muted">
                                                ({{ $note->user ? $note->user->name : trans('shop::fields.from_system') }})
                                            </span>
                                        </strong>
                                    </p>

                                    <p>
                                        {!! nl2br(e($note->message)) !!}
                                    </p>

                                </li>
                            @endforeach
                        </ul>

                        <div class="modal fade" id="newNote" tabindex="-1" role="dialog" aria-labelledby="newNoteLabel">
                            <div class="modal-dialog" role="document">
                                <form class="modal-content" method="post" action="{{ route('shop.admin.order.add_note', $order) }}">
                                    {{ csrf_field() }}
                                    <div class="modal-header">
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                            <span aria-hidden="true">&times;</span>
                                        </button>
                                        <h4 class="modal-title" id="newNoteLabel">{{ trans('shop::order.add_note') }}</h4>
                                    </div>
                                    <div class="modal-body form-group">
                                        <textarea name="note"
                                            class="form-control"
                                            rows="10"
                                            required></textarea>
                                    </div>
                                    <div class="modal-footer">
                                        <button type="button" class="btn btn-default" data-dismiss="modal">
                                            {{ trans('shop::fields.cancel') }}
                                        </button>
                                        <button type="submit" class="btn btn-primary">{{ trans('shop::fields.save') }}</button>
                                    </div>
                                </form>
                            </div>
                        </div>

                    </div>
                </div>

            </div>

            <div class="col col-md-3">

                @foreach($addresses->keys() as $method)

                    <div class="panel panel-default">
                        <div class="panel-heading">
                            <h3 class="panel-title">
                                {{ ucfirst($method) }}
                                @if (count($addresses) == 1)
                                    &amp; {{ $method === 'shipping' ? 'Billing' : 'Shipping' }}
                                @endif
                                Details
                            </h3>
                        </div>
                        <div class="panel-body">
                            <p>
                                <strong>
                                    {{ $addresses[$method]['first_name'] }}&nbsp;
                                    {{ $addresses[$method]['last_name'] }}
                                </strong>
                                <br />
                                {!! nl2br(e($addresses[$method]['full'])) !!}
                            </p>
                        </div>
                    </div>

                @endforeach
                @if (!empty($order->info))
                    <div class="panel panel-default hidden-print">
                        <div class="panel-heading">
                            <h3 class="panel-title">
                                {{ trans('shop::order.device_data') }}
                            </h3>
                        </div>
                        <div class="panel-body">
                            <p>
                                <strong>
                                    {{ trans('shop::order.device') }}:
                                </strong>
                                {{ $order->info->device }}
                                {{ $order->info->device_version ? '(' . $order->info->device_version . ')' : '' }}
                            </p>
                            <p>
                                <strong>
                                    {{ trans('shop::order.os') }}:
                                </strong>
                                {{ $order->info->platform }}
                                {{ $order->info->platform_version ? '(' . $order->info->platform_version . ')' : '' }}
                            </p>
                            <p>
                                <strong>
                                    {{ trans('shop::order.browser') }}:
                                </strong>
                                {{ $order->info->browser }}
                                {{ $order->info->browser_version ? '(' . $order->info->browser_version . ')' : '' }}
                            </p>
                            <p>
                                <strong>
                                    {{ trans('shop::order.ip') }}:
                                </strong>
                                {{ $order->info->ip }}
                            </p>
                        </div>
                    </div>
                @endif
            </div>
        </div>

{{--         <pre>{{ $addresses->toJSON(JSON_PRETTY_PRINT) }}</pre>

        <div class="well well-sm">
            <button type="submit"
                    class="btn btn-success"
                    >Save</button>
            <div class="pull-right">
                <a class="btn btn-default" href="#top">Back to Top</a>
            </div>
        </div>
        {{ csrf_field() }}
    </form> --}}



<div class="modal fade" tabindex="-1" role="dialog" id="payment_information">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title">{{ trans('shop::order.payment_data') }}</h4>
            </div>
            <div class="modal-body">
                <table class="table">
                    <tbody>
                    @foreach ($order->payment as $key => $value)
                        <tr>
                            <th>{{ $key }}</th>
                            <td>{{ $value }}</td>
                        </tr>
                    @endforeach
                    </tbody>
                </table>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">{{ trans('shop::fields.close') }}</button>
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div><!-- /.modal -->


@endsection
