<h5 class="refineSelection js_refineSelection">
    Refine Selection
</h5>

<div class="row">
    <input type="text" placeholder="Search" v-model="options.query">
</div>

<div class="productFilterSelectionWrap">
    <div class="productFilterSelection">

        <div class="selectionsWrap">
            <div id="productFilterSelections">
                <div class="currentSelectionWrap" v-show="options.selected.length > 0">
                    <h3>
                        Current Selection
                    </h3>

                    <div class="currentSelection">
                        <div class="overflowWrap">
                            <a class="filterLink"
                               @click="options.selected = []"
                               v-show="options.selected.length > 1">
                                <i class="fa fa-refresh"></i>Clear All
                            </a>

                            <div v-for="(option, index) in options.selected">
                                <a class="flink" rel="nofollow" @click="removeSelected(index)"><i class="fa fa-times"></i>@{{ option.title }}</a>
                            </div>
                        </div>
                    </div>
                </div> <!-- .currentSelectionWrap -->
            </div>
        </div> <!-- .selectionsWrap -->

        <div class="filterSortBoxWrap"
            v-for="taxonomy in taxonomies"
            v-if="taxonomy.children.length > 0"
        >

            <h3>
                @{{ taxonomy.title }}&nbsp;<i class="fa fa-angle-up"></i>
            </h3>

            <div class="overflowWrap">
                <div class="checkboxRow"
                    v-for="child in taxonomy.children"
                >
                    <input class="ftick"
                        :id="'f_cat_' + child.id + '_chk'"
                        type="checkbox"
                        v-model="child.selected"
                        @click="toggle(child)"
                    >

                    <label :for="'f_cat_' + child.id + '_chk'">
                        <span>
                            <a :href="child.url"
                                class="flink"
                                rel="nofollow"
                            >
                                @{{ child.title }}

                                (@{{ child.product_count }})
                            </a>
                        </span>
                    </label>
                </div> <!-- .checkboxRow -->
            </div> <!-- .overflowWrap -->

        </div> <!-- .filterSortBoxWrap -->

    </div> <!-- .productFilterSelection -->
</div> <!-- .productFilterSelectionWrap -->
