@extends('theme::layouts.public')

@section('content')

    <div class="itemWrap js_itemWrap">

        <div class="itemBackButton">
            <a href="#"><i class="fa fa-angle-left"></i>Back</a>
        </div>

        <div class="item">

            <div class="itemTitleWrap">
                <div class="itemTitle">
                    <h1>{{ $product->node->title }}</h1>
                </div> <!-- .itemTitle -->
            </div> <!-- .itemTitleWrap -->

            <div class="itemImages">
                <div class="largeImage enableZoom"
                     data-zoom-gallery="itemImage"
                 >
                    <img alt="{{ $product->node->title }}"
                         src="{{ $image }}"
                     >
                </div>

                <ul class="thumbs"
                    data-zoom-gallery="itemImage"
                >
                    @foreach ($product->media as $media)
                        <li>
                            <a href="{{ asset('storage/' . $media->getSize('large')) }}"
                                data-large="{{ asset('storage/' . $media->getSize('large')) }}"
                                class="mtcZoomGallery"
                                title="{{ $media->title }}"
                            >
                                <div class="imageWrap">
                                    <img src="{{ asset('storage/' . $media->getSize('small')) }}"
                                        alt="{{ $media->title }}"
                                    >
                                </div>
                            </a>
                        </li>
                    @endforeach
                </ul>
            </div>

            <div class="itemDescription">

                <div class="addToBasketWrap">

                    @include('shop::public.partials.product.price')

                    @if($product->isInStock())

                        <add-to-basket v-cloak
                            inline-template
                            product-in="{{ $product }}"
                            basket-title="{{ trans('shop::basket.title') }}"
                            action="{{ route('shop.basket.store') }}"
                        >

                            <div class="addToBasket">

                                <div v-if="product.variants.length > 1"
                                    class="row itemSizeSelectWrapper"
                                >

                                    <label for="productVariant">
                                        Select Variant
                                    </label>

                                    <div class="inputWrap">
                                        <select id="productVariant"
                                            v-model="formData.selected"
                                                @change="formData.max = formData.selected.stock_quantity"
                                        >
                                            <option v-for="variant in product.variants"
                                                :value="variant"
                                            >
                                                @{{ variant.node.title }}
                                            </option>
                                        </select>
                                    </div>

                                </div>

                                <div class="row quantityRow">
                                    <label for="quantity">
                                        <abbr title="Quantity">Qty</abbr>
                                    </label>

                                    <div class="inputWrap">
                                        <button :disabled="formData.quantity < 2"
                                                @click="formData.quantity--">-</button>
                                        <input type="tel"
                                            v-model="formData.quantity"
                                            :max="formData.max"
                                            id="quantity"
                                            class="text"
                                        >
                                        <button :disabled="formData.quantity >= formData.max"
                                        @click="formData.quantity++">+</button>
                                    </div>
                                </div>

                                <div class="row addToBagRow">
                                    <button id="addToBag"
                                        class="button"
                                        :disabled="!formData.selected"
                                        @click.prevent="add()"
                                    >
                                        Add to {{ trans('shop::basket.title') }}
                                    </button>
                                </div>

                            </div>

                        </add-to-basket>

                    @else
                        <p class="error">This product is temporarily out of stock!</p>
                    @endif

                </div> <!-- .addToBasketWrap -->

                @include('shop::public.partials.product.description')

            </div> <!-- .itemDescription -->
        </div> <!-- .item -->
        @foreach (Event::fire('shop.product.footer', $product) as $view)
            {!! $view !!}
        @endforeach
    </div> <!-- .itemWrap -->

@endsection
