<?php
/**
 * Class BrowseMenuSection
 *
 * @package  Mtc\Shop
 * @author   Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */

namespace Mtc\Shop\Listeners;

use Illuminate\Http\Request;
use Mtc\Core\Taxonomy;
use Mtc\Menus\Events\Admin\GetMenuSections;
use Mtc\Shop\Http\Controllers\BrowseController;

/**
 * Class BrowseMenuSection
 *
 * Retrieve Browse section for Menu builder
 *
 * @package  Mtc\Shop
 * @author   Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
class BrowseMenuSection
{
    /**
     * Handle the event.
     * Return supported menu types as a structured array.
     *
     * @param  GetMenuSections $event
     * @return array
     */
    public function handle(GetMenuSections $event)
    {
        return [
            trans('shop::fields.shop_link') => [
                'type' => 'selector-component',
                'class' => BrowseMenuSection::class,
                'fields' => [
                    'title' => [
                        'type' => 'text',
                        'name' => trans('Title')
                    ],
                    'allow_update' => [
                        'type' => 'hidden',
                    ],
                    'url' => [
                        'type' => 'vue-component',
                        'name' => trans('Link'),
                        'component_name' => 'select-browse-taxonomies',
                        'props' => [
                            'name' => 'new[' . BrowseMenuSection::class . '][taxonomies]',
                            'options' => Taxonomy::all(),

                        ]
                    ]
                ]
            ],
        ];
    }

    /**
     * Generate Url for Browse Menu Entry
     *
     * @param Request $request incoming request
     * @return string url for selected taxonomies in browse
     */
    public static function getUrl(Request $request)
    {
        $selected = collect([]);
        // We need to get the selected taxonomies in a format of [ 'id' => ID ]
        // Due to this we convert the submitted taxonomies to a collection and
        // process each on its own. Each entry is pushed to $selected list as an array in correct format
        collect($request->input("new." . self::class . ".taxonomies"))
            ->each(function ($taxonomy_id) use ($selected) {
                $selected->push([
                    'id' => $taxonomy_id
                ]);
            });

        // Generate a browse url based on the given selections
        return BrowseController::generateUrl($selected->toArray(), 'absolute');
    }
}