<?php

use Illuminate\Database\Seeder;
use Mtc\Core\Node;
use Mtc\Core\CustomFields\CustomField;
use Mtc\Core\CustomFields\CustomGroup;
use Mtc\Core\Taxonomy;

class TaxonomySeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $this->command->comment('Deleting existing taxonomies');
        Node::whereNodeableType(Taxonomy::class)->delete();
        Taxonomy::query()->delete();

        $this->createBasicCategories();

        $this->command->info('Complete!');
    }

    public function createBasicCategories()
    {
        $root = Taxonomy::create(['title' => 'Categories']);
        $root->makeTree([
            [
                'title' => 'Jeans',
            ],
            [
                'title' => 'Outerwear',
                'children' => [
                    [
                        'title' => 'Jackets',
                    ],
                    [
                        'title' => 'Blazers',
                    ],
                    [
                        'title' => 'Parkas',
                    ],
                    [
                        'title' => 'Hooded',
                    ],
                    [
                        'title' => 'Bombers',
                    ],
                    [
                        'title' => 'Quilted',
                    ],
                    [
                        'title' => 'Wax',
                    ],
                    [
                        'title' => 'Overshirts',
                    ],
                    [
                        'title' => 'Puffer',
                    ],
                ],
            ],
            [
                'title' => 'Outlet',
            ],
            [
                'title' => 'Shoes',
                'children' => [
                    [
                        'title' => 'Trainers',
                    ],
                    [
                        'title' => 'Flip Flops',
                    ],
                    [
                        'title' => 'Slippers',
                    ],
                    [
                        'title' => 'Boots',
                    ],
                ],
            ],
            [
                'title' => 'Tees',
                'children' => [
                    [
                        'title' => 'Crew Neck Tees',
                    ],
                    [
                        'title' => 'Hooded Tees',
                    ],
                    [
                        'title' => 'Patterned / Striped Tees',
                    ],
                    [
                        'title' => 'Plain Tees',
                    ],
                    [
                        'title' => 'Polo Shirts',
                    ],
                    [
                        'title' => 'V Neck Tees',
                    ],
                    [
                        'title' => 'Graphic Tees',
                    ],
                ],
            ],
            [
                'title' => 'Accessories',
                'children' => [
                    [
                        'title' => 'Gloves',
                    ],
                    [
                        'title' => 'Bags',
                    ],
                    [
                        'title' => 'Hats',
                    ],
                    [
                        'title' => 'Scarves',
                    ],
                    [
                        'title' => 'Underwear',
                    ],
                    [
                        'title' => 'Wallets',
                    ],
                    [
                        'title' => 'Umbrellas',
                    ],
                ],
            ],
        ]);
    }

    /**
     * Add Google Categories from JSON,
     *
     * Takes about a minute to do this...
     *
     * @return self
     */
    public function createGoogleCategories() {
        $this->command->comment('Creating google categories...');

        $root = Taxonomy::create(['title' => 'Google Categories']);
        $data = file_get_contents(database_path('seeds/data/google_categories.json'));

        $root->makeTree(json_decode($data, true));

        return $this;
    }
}
