@extends('core::layouts.admin')

@section('title', 'Manage Stock Control Settings')

@section('content')

    <form method="POST" action="{{ route('shop.admin.stocksettings.store') }}">

        <div class="well well-sm">
            <button type="submit"
                    class="btn btn-success"
            >Save</button>
        </div>

    @include('core::admin.builder.partials.errors')
        <div class="well">
            <div class="form-group">
                <label for="stock_reserve">Stock Reserve</label>
                <input type="number"
                       name="stock_reserve"
                       id="stock_reserve"
                       class="form-control"
                       placeholder="0"
                       value="{{ Request::old('stock_reserve', $stocksettings->stock_reserve) }}"
                       aria-describedby="stock_reserve_help"
                />
                <span id="stock_reserve_help" class="help-block">
                    If the stock level for an item falls below this value, it will be shown as out of stock on the store
                </span>
                @include('core::layouts.partials.admin.field_error', ['field' => 'stock_reserve'])
            </div>
            <div class="checkbox">
                <label>
                    <input type="hidden" name="stock_notify" value="0">
                    <input type="checkbox"
                           name="stock_notify"
                           value="1"
                           aria-describedby="stock_notify_help"
                           @if (Request::old('stock_nofity', $stocksettings->stock_notify) == 1)
                           checked
                            @endif
                    > Enable Stock notifications
                </label>

                <span id="stock_notify_help" class="help-block">
                    Send email notifications when stock falls below a certain level
                </span>
            </div>
            <div class="form-group">
                <label for="stock_notify_level">Notification level</label>
                <input type="number"
                       name="stock_notify_level"
                       id="stock_notify_level"
                       class="form-control"
                       placeholder="0"
                       value="{{ Request::old('stock_notify_level', $stocksettings->stock_notify_level) }}"
                       aria-describedby="stock_notify_level_help"
                />
                <span id="stock_notify_level_help" class="help-block">
                    The level stock need to fall below before notification emails will be sent
                </span>
                @include('core::layouts.partials.admin.field_error', ['field' => 'stock_notify_level'])
            </div>
            <div class="form-group">
                <label for="stock_notify_email">Notification email address</label>
                <input type="email"
                       name="stock_notify_email"
                       id="stock_notify_email"
                       class="form-control"
                       value="{{ Request::old('stock_notify_email', $stocksettings->stock_notify_email) }}"
                       aria-describedby="stock_notify_email_help"
                />
                <span id="stock_notify_email_help" class="help-block">
                    The email address that low stock notification emails will be sent to
                </span>
                @include('core::layouts.partials.admin.field_error', ['field' => 'stock_notify_email'])
            </div>
        </div>

        <div class="well well-sm">
            <button type="submit"
                    class="btn btn-success"
            >Save</button>
            <div class="pull-right">
                <a class="btn btn-default" href="#top">Back to Top</a>
            </div>
        </div>


        {{ csrf_field() }}
    </form>

@endsection