<?php
/**
 * Web Routes
 *
 * This file is where you may define all of the routes that are handled
 * by your application. Just tell Laravel the URIs it should respond
 * to using a Closure or controller method. Build something great!
 *
 * PHP Version 7
 *
 * @category Mtc\Shop
 * @package  Mtc\Shop
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */

use Mtc\Core\Admin\Menu;
use Mtc\Core\Admin\Tab;
use Mtc\Core\Events\Admin\MenuLoading;
use Mtc\Shop\Contracts\BasketContract;
use Mtc\Shop\Product;
use \Illuminate\Routing\Router;

/**
 * @var Router $router
 */
$router->group(
    [
        'prefix' => config('core.admin_prefix'),
        'middleware' => ['web', 'auth', 'permission:admin'],
        'as' => 'shop.admin.'
    ],
    function (Router $router) {
        $router->resource('products', Admin\ProductController::class);
        $router->resource('products/{product}/variants', Admin\VariantController::class);
        $router->post('products/{product}/media/update_order', Admin\MediaController::class . '@changeOrder');
        $router->resource('products/{product}/media', Admin\MediaController::class);

        $router->get('orders/export', 'Admin\OrderController@export')->name('orders.export');
        $router->get('orders/picking', 'Admin\OrderController@picking')->name('orders.picking');
        $router->post('orders/{order}/add_note', 'Admin\OrderController@addNote')->name('order.add_note');
        $router->post('orders/{order}/status', 'Admin\OrderController@updateStatus')->name('order.update_status');
        $router->resource('orders', 'Admin\OrderController');

        if (config('stock.stock_enabled')) {
            // add routes for stock management if the functionality has been enabled
            $router->get('stocksettings', 'Admin\StockSettingsController@edit')->name('stocksettings.edit');
            $router->post('stocksettings', 'Admin\StockSettingsController@store')->name('stocksettings.store');
            $router->post(
                'stocksettings/{product}/stock_enable',
                'Admin\StockSettingsController@updateProductStockEnable')
                ->name('product.stock_enable');
        }

        $router->group(
            [
                'prefix' => 'shipping',
                'as' => 'shipping.'
            ],
            function ($router) {
                $router->resource('zones', 'Admin\ShippingZoneController');
                $router->resource('flat-rate', 'Admin\ShippingFlatRateController');
            }
        );
    }
);

$router->group([
    'middleware' => ['web']
], function (Router $router) {

    $router->match(
        ['get', 'post'],
        trans('shop::browse.prefix') . '/{query?}',
        BrowseController::class . '@index'
    )->name('shop.browse')
        ->where('query', '.*');

    $router->get('product/{product}/{slug?}', ProductController::class . '@show')->name('shop.product');

    $router->group([
        // By passing through the trans() we can easily customise this route through lang files.
        'prefix' => trans('shop::basket.prefix'),
        'as' => 'shop.basket.'
    ], function (Router $router) {
        $router->post('/', 'BasketController@store')->name('store');
        $router->get('/', 'BasketController@index')->name('index');
        $router->put('/update', 'BasketController@update')->name('update');
    });

    // Checkout flow
    $router->group([
        'prefix' => 'checkout',
        'as' => 'shop.checkout'
    ], function (Router $router) {
        // Routes for managing customer details
        $router->get('customer', 'CheckoutController@customer')->name('start');
        $router->post('customer', 'CheckoutController@customerStore');

        // Routes for managing shipping details
        $router->get('shipping', 'CheckoutController@shipping');
        $router->post('shipping', 'CheckoutController@shippingStore');

        // Routes for managing payment options
        $router->get('payment', 'CheckoutController@payment');
        $router->post('payment', 'CheckoutController@paymentStore');

        // Path to removing a discount from basket
        $router->post('remove_discount', 'CheckoutController@removeDiscount');

        // Path to login from checkout
        $router->post('login', 'CheckoutController@loginAndUpdateBasket');
    });
});
