<?php

namespace Mtc\Shop\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Mtc\Shop\Contracts\OrderContract;

class OrderStatus extends Mailable
{
    use Queueable, SerializesModels;

    /**
     * The order instance.
     *
     * @var Order
     */
    protected $order;

    /**
     * Create a new message instance.
     *
     * @param OrderContract $order
     */
    public function __construct(OrderContract $order)
    {
        $this->order = $order;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->subject('Your ' . config('app.name') . ' order has been ' . strtolower($this->order->status->title))
            ->markdown('shop::public.email.order.status_changed')
            ->with('order', $this->order);
    }
}