<?php
/**
 * Order Surcharge Model
 *
 * @package  Mtc\Shop
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */

namespace Mtc\Shop\Order;

use Illuminate\Database\Eloquent\Model;

/**
 * Order Surcharge model
 *
 * Model storing information about surcharges applied to item
 *
 * @package  Mtc\Shop
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
class OrderSurcharge extends Model
{
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'order_id',
        'surcharge_type',
        'surcharge_id',
        'display_name',
        'value'
    ];

    /**
     * Get the order associated with the address.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function order()
    {
        return $this->belongsTo(Order::class);
    }

    /**
     * Morph the discount to the relevant class.
     *
     * @return \Illuminate\Database\Eloquent\Relations\MorphTo
     */
    public function surcharge()
    {
        return $this->morphTo();
    }
}
