<?php
/**
 *
 * StockReserved Model
 *
 * PHP Version <7>
 *
 * @category Mtc\Shop\Stock
 * @author   Joe Pritchard <joe.pritchard@mtcmedia.co.uk>
 *
 * Created: 07/04/2017 15:42
 *
 */

namespace Mtc\Shop\Stock;

use Illuminate\Database\Eloquent\Builder;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;


/**
 * Class Reserved
 *
 * @package Mtc\Shop\Stock
 */
class Reserved extends Model
{

    protected $table = 'stock_reserved';

    protected $fillable = [
        'basket_id',
        'variant_id',
        'quantity'
    ];

    /**
     * Return only reserved items which have been updated more recently than the config's timeout value
     *
     * @param Builder $query
     *
     * @return Builder
     */
    public function scopeCurrent(Builder $query)
    {
        return $query->where('updated_at', '>=', $this->earliest_reserve_time);
    }

    /**
     * Return only reserved items which have timed out (as defined in the config's timeout value)
     *
     * @param Builder $query
     *
     * @return Builder
     */
    public function scopeOutOfDate(Builder $query)
    {
        return $query->where('updated_at', '<', $this->earliest_reserve_time);
    }

    /**
     * function getEarliestReserveTimeAttribute
     *
     * @return Carbon
     */
    protected function getEarliestReserveTimeAttribute() {
        return (new Carbon)->subMinutes(config('stock.stock_reservation_timeout', 0));
    }


}