<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateProductsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('products', function (Blueprint $table) {
            $table->increments('id');
            $table->boolean('stock_enabled')->index();
            $table->string('price_method')->index();
            $table->decimal('sort_price', 10,2)->nullable()->unsigned();
            $table->timestamps();
        });

        Schema::create('price_per_products', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('product_id')->unsigned();
            $table->decimal('price', 10,2)->unsigned();
            $table->integer('quantity')->unsigned()->index();
            $table->timestamps();

            $table->unique(['product_id', 'quantity']);
            $table->foreign('product_id')
                ->references('id')
                ->on('products')
                ->onDelete('cascade')
                ->onUpdate('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('price_per_products');
        Schema::dropIfExists('products');
    }
}
