<?php
/**
 * Product View Composer
 *
 * PHP Version 7
 *
 * @category Mtc\Shop\Http\ViewComposers
 * @package  Mtc\Shop
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */

namespace Mtc\Shop\Http\ViewComposers;

use Illuminate\View\View;

/**
 * Display any data required for products to a view.
 *
 * @category Mtc\Shop\Http\ViewComposers
 * @package  Mtc\Shop
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */
class ProductComposer
{
    /**
     * Return information about the price methods available to choose from
     * for a product.
     *
     * @param View $view Source View
     *
     * @return void
     */
    public function compose(View $view)
    {
        $view->with(
            [
            'price_methods' => collect(event('core.shop.price_methods'))
                ->flatten() // Allows users to pass arrays if they want
                ->reject(
                    function($method) {
                        return empty($method) || ! class_exists($method);
                    }
                ),
            ]
        );
    }
}
