<?php
/**
 * Order Nodes Model
 *
 * PHP Version 7
 *
 * @category Mtc\Shop\Order
 * @package  Mtc\Shop
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */

namespace Mtc\Shop\Order;

use Mtc\Core\User;
use Illuminate\Database\Eloquent\Model;

/**
 * Private notes about orders, including system generated messages.
 *
 * @category Mtc\Shop\Order
 * @package  Mtc\Shop
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */
class OrderNote extends Model
{
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'order_id',
        // This can be null to allow for 'System' generated messages.
        'user_id',
        'message',
    ];

    /**
     * Get the order associated with the item.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function order()
    {
        return $this->belongsTo(Order::class);
    }

    /**
     * Get the order associated with the item.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
