<?php
/**
 * Shop View Composer Service Provider
 *
 * PHP Version 7
 *
 * @category Mtc\Shop\Providers
 * @package  Mtc\Shop
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */

namespace Mtc\Shop\Providers;

use Illuminate\Support\Facades\View;
use Illuminate\Support\ServiceProvider;
use Mtc\Shop\Http\ViewComposers\ProductComposer;

/**
 * Registers view composers for any views.
 *
 * @category Mtc\Shop\Providers
 * @package  Mtc\Shop
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */

class ComposerServiceProvider extends ServiceProvider
{
    /**
     * Register any events for your application.
     *
     * @return void
     */
    public function boot()
    {
        View::composer('shop::admin.product.form', ProductComposer::class);
    }

    /**
     * Register the service provider.
     *
     * @return void
     */
    public function register()
    {
        //
    }
}
