@extends('theme::layouts.public')

@section('content')

    <div id="checkout">

        @if(! $basket->exists || $basket->items->isEmpty())
            <div class="emptyBasket">
                <h1>{{ trans('shop::basket.empty') }}</h1>
            </div>
        @else
            <basket basket-in="{{ $basket }}"
                inline-template
                v-cloak>
                <form class="checkoutForm" action="{{ route('shop.basket.update') }}" method="post">
                    {{ csrf_field() }}
                    {{ method_field('put') }}

                    <div class="orderSummaryWrap">
                        @include('shop::public.partials.basket.view')
                        <a class="goBack"
                            href="{{ session('previous', route('shop.browse')) }}">
                                Continue Shopping
                        </a>
                    </div><!-- .orderSummaryWrap -->

                    <div class="userDetailsWrap">
                        <div id="userDetails" class="formInline">
                            <h2>{{ trans('shop::basket.checkout_now') }}</h2>

                            @include('shop::public.partials.basket.personal_details')
                            @include('shop::public.partials.basket.billing_details')
                            @include('shop::public.partials.basket.shipping_details')
                            @include('shop::public.partials.basket.terms')

                            <button type="submit"
                                :disabled="!agreedToTerms"
                                class="button right checkoutButton">
                                {{ trans('shop::basket.checkout') }}
                            </button>

                        </div> <!-- #userDetails -->
                    </div><!-- .userDetailsWrap -->

                </form>
            </basket>
        @endif

    </div>

@endsection
