<?php
/**
 * Basket Address Model
 *
 * PHP Version 7
 *
 * @category Mtc\Shop
 * @package  Mtc\Shop
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */

namespace Mtc\Shop;

use Illuminate\Database\Eloquent\Model;
use Mtc\Shop\Contracts\BasketContract;

/**
 * Model storing information about an basket's address.
 *
 * @category Mtc\Shop
 * @package  Mtc\Shop
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */
class BasketAddress extends Model
{
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'basket_id',
        'type',
        'first_name',
        'last_name',
        'address1',
        'address2',
        'city',
        'state',
        'postcode',
        'country',
    ];

    /**
     * Update parent model timestamps.
     *
     * @var array
     */
    protected $touches = ['basket'];

    /**
     * Get the parent basket.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function basket()
    {
        return $this->belongsTo(Basket::class);
    }
}
