<?php
/**
 * Order Paid Event
 *
 * PHP Version 7
 *
 * @category Mtc\Shop\Events
 * @package  Mtc\Shop
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */

namespace Mtc\Shop\Events;

use Mtc\Shop\Contracts\OrderContract;

/**
 * Provide an event including the order for systems to hook into when required.
 *
 * @category Mtc\Shop\Events
 * @package  Mtc\Shop
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */
class OrderPaid
{
    /**
     * The order model.
     *
     * @var null|OrderContract
     */
    public $order = null;

    /**
     * Build the new event, adding in the order model.
     *
     * @param OrderContract $order Incoming Order
     *
     * @return void
     */
    public function __construct(OrderContract $order)
    {
        $this->order = $order;
    }
}
