<?php
/**
 * Class BasketShippingAndPaymentFields
 *
 * @package Mtc\Shop
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

/**
 * Class BasketShippingAndPaymentFields
 *
 * @package Mtc\Shop
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
class BasketShippingAndPaymentFields extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        // Add few fields to baskets table
        Schema::table('baskets', function (Blueprint $table) {
            $table->string('shipping_method_id')->nullable();
            $table->integer('cost_shipping')
                ->unsigned()
                ->nullable();
            $table->string('payment_method')->nullable();
            $table->tinyInteger('same_billing_address')
                ->default(1);
        });

        // Add few fields to orders table
        Schema::table('orders', function (Blueprint $table) {
            $table->text('shipping_method');
            $table->string('shipping_method_id');
        });

        // Add IP address field to order_info
        Schema::table('order_info', function (Blueprint $table) {
            $table->string('ip');
        });

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('baskets', function (Blueprint $table) {
            $table->dropColumn('shipping_method_id');
            $table->dropColumn('cost_shipping');
            $table->dropColumn('payment_method');
            $table->dropColumn('same_billing_address');
        });

        Schema::table('orders', function (Blueprint $table) {
            $table->dropColumn('shipping_method');
            $table->dropColumn('shipping_method_id');
        });

        Schema::table('order_info', function (Blueprint $table) {
            $table->dropColumn('ip');
        });
    }
}
