@extends('core::layouts.admin')

@section('title', 'Picking List')

@section('subtitle', '')

@section('content')

    <div class="well well-sm hidden-print">
        <div class="btn-group">
            <a class="btn btn-primary" href="#" onclick="javascript:print()">
                {{ trans('shop::order.print_picking_note') }}
            </a>
        </div>
        <div class="clear"></div>
    </div>

    <div class="row">
        <div class="col col-md-12">
            <div class="panel panel-default">
                <div class="well">
                    <table class="table table-striped" id="picking_orders">
                        <thead>
                        <tr>
                            <th>Order ID</th>
                            <th>Customer</th>
                            <th>Product ID</th>
                            <th>Product Name</th>
                            <th>Quantity</th>
                            <th>Variant</th>
                            <th>Date</th>
                        </tr>
                        </thead>
                        <tbody>
                        @foreach($orders as $order)
                            @foreach($order->items as $item)
                                <tr>
                                    <td>{{$order->id}}</td>
                                    <td>{{$order->addresses[0]->last_name}}</td>
                                    <td>{{$item->product_id}}</td>
                                    <td>{{$item->product_title}}</td>
                                    <td>{{$item->quantity}}</td>
                                    <td>{{$item->variant_title}}</td>
                                    <td>{{date('M jS Y', strtotime($order->created_at))}}</td>
                                </tr>
                            @endforeach
                        @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
@endsection
