<div id="bagItems">
    <div class="bagItemsHeader">
        <div class="bagThumb">{{ ucfirst(trans('shop::basket.product')) }}</div>
        <div class="bagDescription"></div>
        <div class="bagSize">{{ ucfirst(trans('shop::basket.variant')) }}</div>
        <div class="bagCost">{{ ucfirst(trans('shop::basket.cost')) }}</div>
    </div> <!-- .bagItemsHeader -->

    <div v-for="(line, index) in basket.items">
        @include('shop::public.partials.checkout.view_item')
    </div>

</div> <!-- #bagItems -->

<table id="totals">

    <tr class="subTotal">
        <td>{{ trans('shop::basket.subtotal') }}</td>
        <td>
            <i v-if="isLoading"
               class="fa fa-circle-o-notch fa-spin"></i>
            <span v-else
                id="basketSubTotal">
                @{{ basket.cost_subtotal | currency }}
            </span>
        </td>
    </tr>

    <tr class="surchargeRow" v-for="surcharge in basket.surcharges">
        <td>
            @{{ surcharge.type }}
        </td>
        <td>
            <i v-if="isLoading"
               class="fa fa-circle-o-notch fa-spin"></i>
            <span v-else>
                @{{ surcharge.amount.price | currency }}
            </span>
        </td>
    </tr>

    <tr class="discounts" v-if="visible_discount_form_count">
        <td colspan="2">
            @if (!empty($basket->discount_forms))
                @foreach ($basket->discount_forms as $discount_form)
                    @includeIf($discount_form['template'], $discount_form['data'])
                @endforeach
            @endif
        </td>
    </tr>


    <tr class="discountRow" v-for="discount in basket.discounts">
        <td>
            {{ ucfirst(trans('shop::basket.discount')) }} - @{{ discount.reference }}
            <a @click="removeDiscount(discount)" href="#">
                <i class="fa fa-trash"></i>
            </a>
        </td>
        <td>
            <i v-if="isLoading"
               class="fa fa-circle-o-notch fa-spin"></i>
            <span v-else>
                @{{ discount.amount.price | currency }}
            </span>
        </td>
    </tr>

    @if (Config::get('tax.enabled', true))
        <tr class="taxTotal">
            <td>Tax</td>
            <td>
                <i v-if="isLoading"
                   class="fa fa-circle-o-notch fa-spin"></i>
                <span v-else
                      id="basketVat">
                    @{{ basket.cost_tax | currency }}
                </span>
            </td>
        </tr>
    @endif

    <tr class="checkoutTotal">
        <td>{{ trans('shop::basket.total') }}</td>
        <td>
            <i v-if="isLoading"
               class="fa fa-circle-o-notch fa-spin"></i>
            <span v-else
                  id="basketTotal">
                @{{ basket.cost_total | currency }}
            </span>
        </td>
    </tr>
    @if (\Mtc\Core\Models\Currency::differentCurrencySelected())
        <tr>
            <td>
                {{ trans('shop::basket.currency_notification', [
                    'currency' => $selected_currency->code,
                    'base_currency' => Config::get('core.default_currency')
                ]) }}
            </td>
            <td>
                @{{ basket.cost_total | currency(1) }}
            </td>
        </tr>
    @endif
</table>
