<div class="checkoutSectionWrap">
    <h3 class="shipping">{{ trans('shop::basket.payment_method') }}</h3>

    <ul class="paymentOptions row {{ $errors->has('payment_method') ? 'errorWrap showError' : '' }}">
        <li v-for="method in basket.payment_methods"
            class="row">
            <input type="radio"
                   :id="'method' + method.id"
                   :value="method.id"
                   name="payment_method"
                   @change="changePaymentMethod()"
                   v-model="basket.payment_method"/>
            <label :for="'method' + method.id">
                <span class="title">
                    @{{ method.title }}
                </span>
            </label>
            <div v-if="method.vue_component">
                <component :is="method.vue_component" :basket="basket"></component>
            </div>
        </li>
        @include('shop::public.partials.basket.error', ['errors' => $errors->get('payment_method')])
    </ul>
</div>
