<div id="productFilterItems">
    <ul class="itemsBrowse">
        @include('shop::public.partials.product.item_list')
    </ul>
</div> <!-- .productFilterItems -->

<div id="productFilterPageNumbers">

    <ul class="pagination">

        <li v-if="products.current_page > 1"
            class="prev"
        >
            <a @click="changePage(options.page - 1)"
                rel="prev"
            >
                Previous
            </a>
        </li>

        <li v-for="count in pagination" v-if="products.last_page > 1">

            <span v-if="count == products.current_page">@{{ count }}</span>

            <a v-else
                @click="changePage(count)"
                :class="{flink: count > products.current_page, plink: count < products.current_page, active: count == products.current_page}"
            >
                @{{ count }}
            </a>
        </li>

        <li v-if="products.current_page < products.last_page"
            class="next"
        >
            <a @click="changePage(options.page + 1)"
                rel="next"
            >
                Next
            </a>
        </li>

        <li class="lastItem">
            Page @{{ products.current_page }} of @{{ products.last_page }}
        </li>

    </ul>

</div> <!-- .productFilterPageNumbers -->
