<?php
/**
 * Basket Item Model
 *
 * PHP Version 7
 *
 * @category Mtc\Shop
 * @package  Mtc\Shop
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */

namespace Mtc\Shop;

use Illuminate\Database\Eloquent\Model;
use Mtc\Shop\Contracts\BasketContract;

/**
 * Stores information about the quantity and variant added to the basket.
 *
 * @category Mtc\Shop
 * @package  Mtc\Shop
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */
class BasketItem extends Model
{
    /**
     * The attributes that are mass assignable
     *
     * @var array
     */
    protected $fillable = [
        'basket_id',
        'variant_id',
        'quantity',
    ];

    /**
     * Update parent model timestamps.
     *
     * @var array
     */
    protected $touches = ['basket'];

    /**
     * Get the parent basket.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function basket()
    {
        return $this->belongsTo(Basket::class);
    }

    /**
     * Get the parent variant.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function variant()
    {
        return $this->belongsTo(Variant::class);
    }

    /**
     * Process the basket item by adding url and basket price
     *
     * @return BasketItem $this processed item with price and url set
     */
    public function getProcessedItem()
    {

        $this->main_image = 'http://placehold.it/500x500';
        if ($this->variant->product->media->isEmpty() === false) {
            $this->thumb_url = asset($this->variant->product->media->first()->getSize('thumb'));
        }

        $this->url = $this->variant->product->getUrl();
        $this->price_unit = $this->variant
            ->prices
            ->multiple($this->quantity)
            ->price;
        $this->price_total = $this->price_unit * $this->quantity;
        return $this;
    }
}
