<?php
/**
 * Discount Contract
 *
 * PHP Version 7
 *
 * @category Mtc\Shop\Contracts
 * @package  Mtc\Shop
 * @author   Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */

namespace Mtc\Shop\Contracts;

use Illuminate\Http\Request;
use Closure;

/**
 * This interface defines the necessary methods for building a Discount
 *
 * @category Mtc\Shop\Contracts
 * @package  Mtc\Shop
 * @author   Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
interface DiscountContract
{
    /**
     * Register a discount provider
     * This method must contain following code if it applies/is enabled
     *
     * Event::listen('Discount::getList', function () {
     *     return self::class;
     * });
     */
    public static function register();

    /**
     * Bootstrap discount
     * All enabled discounts need to have a method called loadDiscounts.
     * This method checks if discount applies and adds this discount instance to basket
     *
     * @param BasketContract $basket Basket instance
     * @param Closure $next next discount in the pipeline to check
     */
    public static function loadDiscount(BasketContract $basket, Closure $next);
}
