<?php
/**
 * Order Status Updated Event
 *
 * PHP Version 7
 *
 * @category Mtc\Shop\Events
 * @package  Mtc\Shop
 * @author   James Neill <james.neill@mtcmedia.co.uk>
 */

namespace Mtc\Shop\Events;

use Mtc\Shop\Contracts\OrderContract;

/**
 * Provide an event including the order for systems to hook into when required.
 *
 * @category Mtc\Shop\Events
 * @package  Mtc\Shop
 * @author   James Neill <james.neill@mtcmedia.co.uk>
 */
class OrderStatusUpdated
{
    /**
     * The order model.
     *
     * @var null|OrderContract
     */
    public $order = null;

    /**
     * Build the new event, adding in the order model.
     *
     * @param OrderContract $order Updated Order
     *
     * @return void
     */
    public function __construct(OrderContract $order)
    {
        $this->order = $order;
    }
}