<?php
/**
 * Slider Service Provider
 *
 * @package  Mtc\SlideShow
 * @author   Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
namespace Mtc\Slideshow\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Route;
use Mtc\Slideshow\Models\Slide;
use Mtc\Slideshow\Models\Slider;

/**
 * Connect the SlideShow Provider to Laravel
 *
 * @package  Mtc\SlideShow
 * @author   Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
class SliderServiceProvider extends ServiceProvider
{
    /**
     * Boot the service provider.
     *
     * @return void
     */
    public function boot()
    {
        $this->defineResources();
        $this->defineRoutes();
        $this->loadTranslationsFrom(__DIR__ . '/../../resources/lang', 'slideshow');
    }

    /**
     * Register the service provider.
     *
     * @return void
     */
    public function register()
    {
        $this->publishes([
            __DIR__ . '/../../database/seeds/' => database_path('seeds')
        ], 'seeds');

    }

    /**
     * Define the resources for this package.
     *
     * @return void
     */
    protected function defineResources()
    {
        $this->loadViewsFrom(__DIR__ . '/../../resources/views', 'slideshow');
        $this->loadMigrationsFrom(__DIR__ . '/../../database/seeds');
        $this->mergeConfigFrom(__DIR__ . '/../../config/slideshow.php', 'slideshow');
        $this->mergeConfigFrom(__DIR__ . '/../../config/media.php', 'media');
    }

    /**
     * Define the routes.
     *
     * @return void
     */
    protected function defineRoutes()
    {
        Route::model('slide', Slide::class);
        Route::model('slide-show', Slider::class);

        /**
         * If the routes have not been cached, we will include them in a route group
         * so that all of the routes will be conveniently registered to the given
         * controller namespace. After that we will load the Core routes file.
         */
        if (! $this->app->routesAreCached()) {
            Route::group(
                ['namespace' => 'Mtc\Slideshow\Http\Controllers'],
                function ($router) {
                    $path = dirname(dirname(__DIR__)) . '/routes';
                    foreach (glob("{$path}/*.php") as $file) {
                        include $file;
                    }
                }
            );
        }
    }

}
