<slider inline-template>
    <div class="sliderContainer">
        <div class="sliderWrap">
            <div class="slider">
                <slick :options="slick_options">
                    @foreach ($slider->slides as $slide)
                        @if ($slide->viewable())
                            <li>
                                @if ($slide->custom('Link'))
                                    <a href="{{ $slide->custom('Link') }}">
                                        @endif
                                        <picture>
                                            <source srcset="{{ $slide->media->getSize('mobile') }}"
                                                    media="(max-width: 640px)">
                                            <img srcset="{{ $slide->media->getSize('desktop') }}"
                                                 alt="{{ $slide->media->title }}">
                                        </picture>

                                        <div class="innerText">
                                            <div class="slideshowPosition">
                                                <div class="slideshowText">

                                                    @if ($slide->custom('Title'))
                                                        <h2>{{ $slide->custom('Title') }}</h2>
                                                    @endif

                                                    @if ($slide->custom('Sub Title'))
                                                        <h2>{{ $slide->custom('Sub Title') }}</h2>
                                                    @endif

                                                    @if ($slide->custom('Link') && $slide->custom('Button Text'))
                                                        <div class="button">
                                                            {{ $slide->custom('Button Text') }}
                                                        </div>
                                                    @endif

                                                </div> <!-- .slideshowText -->
                                            </div> <!-- .slideshowPosition -->
                                        </div> <!-- .innerText -->

                                        @if ($slide->custom('Link'))
                                    </a>
                                @endif
                            </li>
                        @endif
                    @endforeach
                </slick>
            </div>
        </div> <!-- .sliderWrap -->
    </div> <!-- .sliderContainer -->
</slider>