<?php
use Illuminate\Routing\Router;
/**
 * Web Routes
 *
 * This file is where you may define all of the routes that are handled
 * by your application. Just tell Laravel the URIs it should respond
 * to using a Closure or controller method.
 *
 * @package  Mtc\Slideshow
 * @author   Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 * @var Router $router
 */


$router->group([
    'prefix' => 'admin',
    'middleware' => ['web', 'auth', 'permission:admin'],
    'as' => 'slider.admin.'
], function(Router $router) {
    $router->post('slide-show/{slider}/slides/update_order', Admin\SlideController::class . '@changeOrder');
    $router->resource('slide-show/{slider}/slides', Admin\SlideController::class);
    $router->resource('slide-show', Admin\SlideShowController::class);
});