<?php
/**
 * Class Slide
 *
 * @package Mtc\Slideshow
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */

namespace Mtc\Slideshow\Models;

use Illuminate\Database\Eloquent\Model;
use Mtc\Core\Media;
use Mtc\Core\Nodeable;
use Mtc\Core\Node;
use Illuminate\Support\Facades\Auth;

/**
 * Class Slide
 *
 * Slide model management
 *
 * @package Mtc\Slideshow
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 * @version 2017-06-14
 */
class Slide extends Model
{
    use Nodeable;

    /**
     * The attributes to load with this object when instantiating
     *
     * @var array
     */
    protected $with = [
        'node'
    ];

    /**
     * @var string $touches attributes that get updated when model is saved
     */
    protected $touches = [
        'node',
    ];

    /**
     * Relationship to media instance
     *
     * @return \Illuminate\Database\Eloquent\Relations\MorphMany
     */
    public function media()
    {
        return $this->morphMany(Media::class, 'parent');
    }

    /**
     * Check whether slide can be viewed
     *
     * @return bool whether slide is viewable
     */
    public function viewable()
    {
        return $this->node->status === Node::NODE_STATUS_PUBLISHED
            && ($this->node->visibility == Node::NODE_VISIBILITY_PUBLIC || Auth::user()->can('admin'));
    }
}