<?php
/**
 * Slider Service Provider
 *
 * @package  Mtc\SlideShow
 * @author   Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
namespace Mtc\Slideshow\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Event;
use Mtc\Core\Events\Admin\MenuLoading;
use Mtc\Core\Admin\Menu as AdminMenu;
use Mtc\Core\Events\Admin\RegisterCustomGroupModels;
use Mtc\Slideshow\Http\Controllers\Admin\SlideController;
use Mtc\Slideshow\Http\Controllers\Admin\SlideShowController;
use Mtc\Slideshow\Models\Slide;
use Mtc\Slideshow\Models\Slider;

/**
 * Connect the SlideShow Provider to Laravel
 *
 * @package  Mtc\SlideShow
 * @author   Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
class EventServiceProvider extends ServiceProvider
{
    /**
     * Boot the service provider.
     *
     * @return void
     */
    public function boot()
    {

        Event::listen(
            RegisterCustomGroupModels::class, function ($event) {
            $event->group
                ->registerModel(Slide::class);
        }
        );

        // Admin Navigation Menu construct
        Event::listen(
            MenuLoading::class, function () {
            AdminMenu::addMenu(
                'content',
                trans('slideshow::fields.slideshow'),
                '',
                'slide_shows',
                'glyphicon glyphicon-picture');

            AdminMenu::addSubMenu(
                'slide_shows',
                trans('slideshow::fields.manage_slider' . (config('slideshow.multiple_sliders') ? 's' : '') ),
                '',
                action('\\' . SlideShowController::class . '@index'),
                'manage_slider');
            if (config('slideshow.multiple_sliders')) {
                foreach (Slider::all() as $slide_show) {
                    AdminMenu::addSubMenu(
                        'slide_shows',
                        $slide_show->node->title,
                        $slide_show->capability ?? '',
                        action('\\' . SlideController::class . '@index', [$slide_show->id]),
                        'manage_slider');
                }
            }
        });
    }
}
