<?php
/**
 * Kernel Class
 *
 * PHP Version 7
 *
 * @category Mtc\SocialFeed\Console
 * @package  Mtc\SocialFeed\Console
 * @author   Anthony Grimes <anthony.grimes@mtcmedia.co.uk>
 * @version 2017-07-26
 */

namespace Mtc\SocialFeed\Console;

use \Mtc\Core\Console\Kernel as ConsoleKernel;
use Illuminate\Console\Scheduling\Schedule;

/**
 * Kernel Class
 *
 * PHP Version 7
 *
 * @category Mtc\SocialFeed\Console
 * @package  Mtc\SocialFeed\Console
 * @author   Anthony Grimes <anthony.grimes@mtcmedia.co.uk>
 * @version 2017-07-26
 */
class Kernel extends ConsoleKernel
{
    /**
     * The Artisan commands provided by your application.
     *
     * @var array
     */
    protected $commands = [
        Commands\UpdateSocialFeedCommand::class
    ];

    /**
     * Define the application's command schedule.
     *
     * @param  \Illuminate\Console\Scheduling\Schedule  $schedule
     * @return void
     */
    protected function schedule(Schedule $schedule)
    {
        parent::schedule($schedule);

        $schedule->command('socialfeed:update')->everyThirtyMinutes();
    }

    /**
     * Register the Closure based commands for the application.
     *
     * @return void
     */
    protected function commands()
    {
        require base_path('routes/console.php');
    }
}