<?php

namespace Mtc\SocialFeed\Http\Controllers;

use Illuminate\Http\Request;
use Mtc\Core\Http\Controllers\Controller;
use Mtc\SocialFeed\SocialFeed;

class SocialFeedController extends Controller
{
    public function handleRequest(Request $request)
    {
        if ($request->type == 'combined') {
            $query = SocialFeed::orderBy('date_posted', 'desc')
                ->take($request->amount);

        } else {

            $query = SocialFeed::orderBy('date_posted', 'desc')
                ->take($request->amount);

            if (!empty($request->type)) {
                $query->where('type', $request->type);
            }
        }

        return response()->json($query->get());
    }
}