# Social Feed

## Facebook
To enable Facebook integration you must first setup an application, this can be done through Facebook's [developers](https://developers.facebook.com/) page.  Once your application is created you will then be able to access the identifier and secret key on the application dashboard, combined with the page identifier these can then be place into your `.env` file with the appropriate keys.  

The page identifier can be either the username displayed in the URL or the unique identifier, it is however recommended to use the unique identifier as this is static and will not change. This can be obtained through the [Graph Explorer](https://developers.facebook.com/tools/explorer?method=GET&path=mtcmedialtd&version=v2.9) on Facebook.  

e.g. `mtcmedia => 173612386061031`

### Environment Variables
These should be set in your `.env` file, the following are required:  

| Key | Description |
| ------------- |-------------|
| `FACEBOOK_APP_ID` | App Identifier |
| `FACEBOOK_APP_SECRET` | App Secret Key |
| `FACEBOOK_PAGE_ID` | Page Identifier |

## Google+
To enable Google+ integration you must first setup an application, this can be done through Google's [developer console](https://console.developers.google.com/projectcreate).  Once your application is created, navigate to the [credentials](https://console.developers.google.com/apis/credentials) page and create an API key (not OAuth) combined with the page identifier these can then be place into your `.env` file with the appropriate keys.  

The page identifier **must** be the page's unique 21 digit indentifier, this can be extracted from the pages URL.  

e.g. `+mtcmedia => 118063575588149485705`

### Environment Variables
These should be set in your `.env` file, the following are required:  

| Key | Description |
| ------------- |-------------| 
| `GOOGLE_ACCESS_TOKEN` | Access Token/API Key |
| `GOOGLE_PAGE_ID` | Page Identifier |  

## Instagram
To set-up Instagram integration, navigate [here](https://www.instagram.com/developer/), register an account and create an application ensuring this is for the account you wish to retrieve information about, *i.e. register the client account as a developer account*.  

After-which you will want to follow the information found [here](https://www.instagram.com/developer/authentication/) for Client-Side (Implicit) Authentication. This is very quick and can be done in any browser. Once you have retrieved your *INSTAGRAM_ACCESS_TOKEN*, you can feed this information into your `.env` file with the same name as above.  

Instagram requires this method of authentication unlike other services where you can pre-verify your app, you must instead verify each account wanting to access your app and use the individuals access_token for API requests.  

The access token doesn't expire but they do have limits, please refer to the [Instagram documentation](https://www.instagram.com/developer/) for more details.  

### Environment Variables
These should be set in your `.env` file, the following are required:  

| Key | Description |
| ------------- |-------------| 
| `INSTAGRAM_ACCESS_TOKEN` | Access Token |  

## Twitter
To set-up Twitter integration, navigate [here](https://dev.twitter.com/), register an account, and create any generic application to receive your *TWITTER_CONSUMER_KEY*, *TWITTER_CONSUMER_SECRET*, *TWITTER_ACCESS_TOKEN* and *TWITTER_ACCESS_TOKEN_SECRET*.  

Once you've copied this information from the [apps](apps.twitter.com) webpage under **"Keys and Access Tokens"** you may also retrieve the *TWITTER_ID* of the user/twitter account you wish to retrieve information about.  

Feed this information into your `.env` file under the same names as above.  

The API details don't expire however they do have limits, please refer to the [Twitter documentation](https://dev.twitter.com/docs) for more details.  

### Environment Variables
These should be set in your `.env` file, the following are required:  

| Key | Description |
| ------------- |-------------| 
| `TWITTER_CONSUMER_KEY` | Consumer Key |
| `TWITTER_CONSUMER_SECRET` | Consumer Secret |
| `TWITTER_ACCESS_TOKEN` | Access Token |
| `TWITTER_ACCESS_TOKEN_SECRET` | Access Token Secret |  
| `TWITTER_ID` | Page ID |  

## CSS/LESS & JS

Add `@import "../../../vendor/mtc/socialfeed/resources/assets/less/socialfeed";` to the `app.less` file.  

Add `require('../../../vendor/mtc/socialfeed/resources/assets/js/app');` to your main `app.js` file.  

## Vue Component 

We have set up a Vue Component for use when this is needed. You may declare `<socialfeed></socialfeed>` which will by default pull back the 10 most recent feeds.    

You may also declare the types individually, with the amounts like so:  


- `<socialfeed type="facebook" amount="5"></socialfeed>`  
- `<socialfeed type="twitter" amount="5"></socialfeed>`  
- `<socialfeed type="googleplus" amount="5"></socialfeed>`  
- `<socialfeed type="instagram" amount="5"></socialfeed>`  


Or to pull back all feeds and a specific amount you may do `<socialfeed type="combined" amount="50"></socialfeed>`

## Useful Snippets


```
FACEBOOK_APP_ID=
FACEBOOK_APP_SECRET=
FACEBOOK_PAGE_ID=

GOOGLE_ACCESS_TOKEN=
GOOGLE_PAGE_ID=

INSTAGRAM_ACCESS_TOKEN=

TWITTER_CONSUMER_KEY=
TWITTER_CONSUMER_SECRET=
TWITTER_ACCESS_TOKEN=
TWITTER_ACCESS_TOKEN_SECRET=
TWITTER_ID=
```

## Disclaimer

Symlinks are not your not friend during development, npm run dev will fail due to this issue: https://github.com/webpack/webpack/issues/1643
