<?php
/**
 * UpdateSocialFeedCommand Class
 *
 * PHP Version 7
 *
 * @category Mtc\SocialFeed\Console\Commands
 * @package  Mtc\SocialFeed\Console\Commands
 * @author   Anthony Grimes <anthony.grimes@mtcmedia.co.uk>
 * @version 2017-07-26
 */
namespace Mtc\SocialFeed\Console\Commands;

use Illuminate\Console\Command;
use Mtc\SocialFeed\Twitter\Feed as Twitter;
use Mtc\SocialFeed\Facebook\Feed as Fb;
use Mtc\SocialFeed\Instagram\Feed as Instagram;
use Mtc\SocialFeed\Google\Feed as Google;

/**
 * UpdateSocialFeedCommand Class
 *
 * PHP Version 7
 *
 * @category Mtc\SocialFeed\Console\Commands
 * @package  Mtc\SocialFeed\Console\Commands
 * @author   Anthony Grimes <anthony.grimes@mtcmedia.co.uk>
 * @version 2017-07-26
 */
class UpdateSocialFeedCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'socialfeed:update';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Update and gather all socialfeed feeds';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        $this->updateFeeds();
    }

    /**
     * Update all enabled feeds
     */
    public function updateFeeds()
    {
        if (config('socialfeed.twitter.id')) {
            $this->updateTwitterFeed();
        }
        if (config('socialfeed.facebook.app_id')) {
            $this->updateFacebookFeed();
        }
        if (config('socialfeed.instagram.access_token')) {
            $this->updateInstagramFeed();
        }
        if (config('socialfeed.google.access_token')) {
            $this->updateGooglePlusFeed();
        }
    }

    /**
     * Update Twitter feed
     */
    public function updateTwitterFeed()
    {
        $twitter = new Twitter();
        $twitter->getFeed();
    }

    /**
     * Update facebook feed
     */
    public function updateFacebookFeed()
    {
        $fb = new Fb();
        $fb->getFeed();
    }

    /**
     * Update instagram feed
     */
    public function updateInstagramFeed()
    {
        $instagram = new Instagram();
        $instagram->getFeed();
    }

    /**
     * Update Google plus feed
     */
    public function updateGooglePlusFeed()
    {
        $google = new Google();
        $google->getFeed();
    }
}
