<?php
namespace Mtc\SocialFeed\Providers;

use Illuminate\Support\ServiceProvider;
use Blade;
use Route;
use Illuminate\Routing\Router;
use Mtc\SocialFeed\SocialFeed;
use Mtc\SocialFeed\Http\Controllers;
use Mtc\SocialFeed\Console\Commands\UpdateSocialFeedCommand;

class SocialFeedServiceProvider extends ServiceProvider
{
    /**
     * Register the service provider and load config.
     *
     * @return bool
     */
    public function register()
    {
        $this->mergeConfigFrom(
            __DIR__ . '/../../config/socialfeed.php', 'socialfeed'
        );

        $this->app->singleton('mtc.socialfeed.console.kernel', function($app) {
            $dispatcher = $app->make(\Illuminate\Contracts\Events\Dispatcher::class);
            return new \Mtc\SocialFeed\Console\Kernel($app, $dispatcher);
        });

        $this->app->make('mtc.socialfeed.console.kernel');

        $this->loadViewsFrom(__DIR__ . '/../../resources/views', 'socialfeed');
        $this->loadMigrationsFrom(__DIR__ . '/../../database/migrations');

        $this->publishes([
            __DIR__ . '/../../resources/assets/less' => public_path('assets/less'),
        ], 'resources');

        if ($this->app->runningInConsole()) {
            $this->publishes([
                __DIR__ . '/../../config/socialfeed.php' => config_path('socialfeed.php'),
            ], 'config');
            $this->commands([
                UpdateSocialFeedCommand::class
            ]);
        }
    }
    /**
     * Boot the service provider if component is enabled.
     *
     * @return void
     */
    public function boot()
    {
        $this->defineRoutes();
    }

    /**
     * Define the routes for the api to listen to
     */
    public function defineRoutes()
    {
        Route::model('socialfeed', SocialFeed::class);
        if (!$this->app->routesAreCached()) {
            Route::group([
                'namespace' => '\Mtc\SocialFeed\Http\Controllers',
                'middleware' => ['web'],
                'as' => 'socialfeed.'
            ], function (Router $router) {
                $router->get('socialfeed/posts/{type}/{amount}', 'SocialFeedController@handleRequest');
            });
        }
    }
}