<?php

namespace Mtc\SocialFeed;

use Illuminate\Database\Eloquent\Model;

class SocialFeed extends Model
{
    /**
     * Model table
     *
     * @var string $table
     */
    protected $table = 'social_feed';

    /**
     * Mass assignable variables
     *
     * @var array $fillable
     */
    protected $fillable = [
        'post_id',
        'message',
        'likes',
        'image_url',
        'permalink',
        'date_posted',
        'type',
        'created_at',
        'updated_at'
    ];

    /**
     * Hide variables from being displayed in json
     *
     * @var array $hidden
     */
    protected $hidden = [
        'created_at',
        'updated_at',
        'id',
    ];

    /**
     * Cast variables to certain types
     *
     * @var array $casts
     */
    protected $casts = [
        'date_posted' => 'datetime',
        'updated_at' => 'datetime',
        'created_at' => 'datetime',
    ];
}
