<!doctype html>
<html class="no-js" lang="en">
    <head>
        <title>@yield('title')</title>
        <meta charset="utf-8" />
        <meta name="robots" content="@yield('robots')" />
        <meta name="description" content="@yield('meta.description')" />
        <meta name="viewport" content="width=device-width">

        @yield('head')

        <link href="{{ elixir('css/app.css') }}" rel="stylesheet">


    </head>
    <body>
        <div class="siteWrapper" id="app">
            @include('theme::layouts.partials.header')

            <div class="siteInnerWrapper">
                <div id="content" role="main">
                    @yield('content')
                </div> <!-- #content -->
            </div> <!-- .siteInnerWrapper -->

            @include('theme::layouts.partials.footer')
        </div>

        <!-- Global Core Object -->
        <script>
            window.Laravel = { csrfToken: '{{ csrf_token() }}' };
        </script>
        @stack('pre_scripts', '')
        <script src="{{ elixir('js/app.js') }}"></script>
        @stack('scripts', '')
    </body>
</html>
