<!doctype html>
<html class="no-js" lang="en">
<head>
    <title>{{ $seo_data->title }}</title>
    <meta charset="utf-8" />
    <meta name="robots" content="@yield('robots')" />
    <meta name="description" content="{{ $seo_data->description }}" />
    @if (!empty($meta_author))
        <meta name="author" content="{{ $meta_author }}">
    @endif
    <meta name="viewport" content="width=device-width">

    @yield('head')

    <link href="{{ mix('/css/app.css') }}" rel="stylesheet">


    @if (!empty($seo_tags['head']))
        @foreach ($seo_tags['head'] as $tag)
            @includeIf($tag['template'], $tag['with'])
        @endforeach
    @endif
</head>
<body>
@if (!empty($seo_tags['body']))
    @foreach ($seo_tags['body'] as $tag)
        @includeIf($tag['template'], $tag['with'])
    @endforeach
@endif
<div class="siteWrapper" id="app">
    @include('theme::layouts.partials.header')

    <div class="siteInnerWrapper">
        <div id="content" role="main">
            @includeIf('core::public.breadcrumbs')
            @yield('content')
        </div> <!-- #content -->
    </div> <!-- .siteInnerWrapper -->

    @include('theme::layouts.partials.footer')
</div>

<!-- Global Core Object -->
<script>
    window.Laravel = { csrfToken: '{{ csrf_token() }}' };
    @if (config('core.address_finder.enabled'))
        window.address_finder = true;
    @endif
</script>
@stack('pre_scripts', '')
@routes
<script src="{{ mix('/js/app.js') }}"></script>
@stack('scripts', '')

@if ($knowledge_graph)
    <script type="application/ld+json" src="{{ $knowledge_graph }}"></script>
@endif
</body>
</html>