<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class AddWebhookTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('webhooks', function (Blueprint $table) {
            $table->increments('id');
            $table->string('url');
            $table->string('event');
            $table->string('event_name');
            $table->timestamps();
        });

        Schema::create('webhook_logs', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('webhook_id')->unsigned()->nullable();
            $table->foreign('webhook_id')->references('id')->on('webhooks')->onDelete('set null');
            $table->string('url');
            $table->text('payload');
            $table->integer('status');
            $table->text('response');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('webhooks');
        Schema::drop('webhook_logs');
    }
}
