<?php

namespace Mtc\Components\Webhooks\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Response;
use Mtc\Components\Webhooks\Webhook;

/**
 * Class WebhookController
 *
 * @package Mtc\Components\Webhooks\
 */
class WebhookController extends Controller
{
    /**
     * Get all of the webhooks generated by the user.
     *
     * @return Response
     */
    public function index()
    {
        return response(Webhook::query()
            ->orderBy('created_at', 'desc')
            ->get());
    }

    /**
     * Create a new webhook for the user.
     *
     * @param  Request $request
     * @return Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'event' => 'required',
            'event_name' => 'required|alpha_dash',
            'url' => 'required|url',
        ]);

        $hook = Webhook::query()
            ->create([
                'url' => $request->url,
                'event' => $request->event,
                'event_name' => $request->event_name,
            ]);
        return response()->json($hook);
    }

    /**
     * Update the given webhook.
     *
     * @param  Request $request
     * @param  string $webhookId
     * @return Response
     */
    public function update(Request $request, $webhookId)
    {
        $this->validate($request, [
            'event' => 'required',
            'event_name' => 'required|alpha_dash',
            'url' => 'required|url',
        ]);

        $webhook = Webhook::query()
            ->where('id', $webhookId)
            ->firstOrFail();

        $webhook->url = $request->url;
        $webhook->event = $request->event;
        $webhook->event_name = $request->event_name;
        $webhook->save();
    }

    /**
     * Delete the given webhook.
     *
     * @param  Request $request
     * @param  string $webhook_id
     */
    public function destroy(Request $request, $webhook_id)
    {
        Webhook::query()
            ->where('id', $webhook_id)
            ->firstOrFail()
            ->delete();
    }

}