<?php

namespace Mtc\Components\Webhooks\Providers;

use Event;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\ServiceProvider;
use Mtc\Components\Webhooks\Http\Controllers\WebhookController;
use Mtc\Components\Webhooks\Jobs\RunWebhook;
use Mtc\Components\Webhooks\Webhook;
use Route;

/**
 * Connect the Webhook functionality to Laravel
 *
 * @package  Mtc\Components\Webhooks
 * @author   Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
class WebhookServiceProvider extends ServiceProvider
{
    use DispatchesJobs;

    /**
     * Boot the service provider.
     *
     * @return void
     */
    public function boot()
    {
        $this->defineResources();
        $this->defineRoutes();

        Cache::rememberForever(Webhook::CACHE_KEY,
            function () {
                return Webhook::all();
            })
            ->each(function (Webhook $hook) {
                Event::listen($hook->event, function ($payload) use ($hook) {
                    if ($payload instanceof Model) {
                        if (!empty($payload->getDirty())) {
                            $this->dispatch(new RunWebhook($hook, $payload));
                        }
                    } else {
                        $this->dispatch(new RunWebhook($hook, $payload));
                    }
                });
            });
    }

    /**
     * Register the service provider.
     *
     * @return void
     */
    public function register()
    {
        //
    }

    /**
     * Define the resources for this package.
     *
     * @return void
     */
    protected function defineResources()
    {
        $this->loadMigrationsFrom(__DIR__ . '/../../database/migrations');
        $this->mergeConfigFrom(__DIR__ . '/../../config/webhooks.php', 'webhooks');
        $this->publishes([
            __DIR__ . '/../../config/webhooks.php' => config_path('webhooks.php'),
        ]);

    }

    /**
     * Load routes to send the form and to process the incoming request.
     *
     * @return void
     */
    protected function defineRoutes()
    {
        if (!$this->app->routesAreCached()) {

            Route::group([
                'middleware' => 'api'
            ], function ($router) {
                $router->resource('webhooks', WebhookController::class);

            });

        };
    }
}
