<?php

namespace Mtc\Components\Webhooks;

use GuzzleHttp\Client;
use GuzzleHttp\Exception\GuzzleException;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Cache;

/**
 * Class Webhook
 *
 * @package Mtc\Components\Webhooks
 */
class Webhook extends Model
{
    const CACHE_KEY = 'mtc_all_webhooks';

    /**
     * Mass assignable attributes
     *
     * @var string[] $fillable
     */
    protected $fillable = [
        'url',
        'event',
        'event_name',
    ];

    protected static function boot()
    {
        parent::boot();

        self::saved(function ($hook) {
            Cache::forget(Webhook::CACHE_KEY);
        });

        self::deleted(function ($hook) {
            Cache::forget(Webhook::CACHE_KEY);
        });
    }

    /**
     * Relationship with log entries
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function logs()
    {
        return $this->hasMany(WebhookLog::class);
    }

    /**
     * Run the webhook
     *
     * @param $payload
     */
    public function run($payload)
    {
        $client = new Client([
            'headers' => [
                'Content-Type' => 'application/json',
                'Accept' => 'application/json',
            ],
            // Timeout after 2s to prevent from unnecessary load
            'connect_timeout' => 2

        ]);

        try {
            $client->request($this->url, [
                'form_params' => json_encode($payload)
            ]);
        } catch (GuzzleException $e) {
        }
    }
}