<?php

namespace Mtc\Components\Webhooks;

use Illuminate\Database\Eloquent\Model;

/**
 * Class WebhookLog
 * Log entries for webhook executions
 *
 * @package Mtc\Components\Webhooks
 */
class WebhookLog extends Model
{
    /**
     * Mass assignable attributes
     *
     * @var string[] $fillable
     */
    protected $fillable = [
        'url',
        'payload',
        'status',
        'response',
    ];

    /**
     * Relationship with the webhook
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function webhook()
    {
        return $this->belongsTo(Webhook::class, 'webhook_id');
    }
}